%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FileName:            mfRxTimeslotSyn.m
%  Description:         ͨPSCػʱ϶ͬ
%  Reference:           3GPP TS 25.211, 5.3.3.5 Synchronisation Channel (SCH)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  Parameter List:       
%       Output Parameter
%           search_flag     طǷ,0ʾδط壬1ʾط
%           timeslot_star	ʱ϶ʼĵ
%           mod_PSC_corr    ͬؽڻطͼ          
%       Input Parameter
%           input_data      
%           sample_rate     
%           corr_length     س
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  History
%    1. Date:           2017-12-1
%       Author:         david.lee
%       Version:        1.0 
%       Modification:   
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [search_flag, timeslot_star, mod_PSC_corr] = CDMA_RxTimeslotSyn(input_data,sample_rate,corr_length)   

%% ʵ
%ͬ
a=[1, 1, 1, 1, 1, 1, -1, -1, 1, -1, 1, -1, 1, -1, -1, 1];
PSC=(1+1)*[a, a, a, -a, -a, a, -a, -a, a, a, a, -a, a, -a, a, a];
PSC_data=256*sample_rate;
PSC_sample=zeros(1,PSC_data);
for code_num=1:256
    for sample_num=1:sample_rate
        PSC_sample((code_num-1)*sample_rate+sample_num)=PSC(code_num);
    end
end

%ͬ
PSC_correlation=zeros(1,corr_length);
for data_num=1:corr_length;
    for n=1:PSC_data
        PSC_correlation(data_num)=PSC_correlation(data_num)+input_data(data_num+n-1)*PSC_sample(n);
    end
end
mod_PSC_corr=abs(PSC_correlation);

%жطǷ
timeslot_star=find(max(mod_PSC_corr)==mod_PSC_corr);

if max(mod_PSC_corr) > 2*(sum(mod_PSC_corr)-max(mod_PSC_corr))/(corr_length-1)
    search_flag = 1;
else
    search_flag = 0;
end
end
